create or replace function addcolumn()
returns void as
$body$
begin
	IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_TYPE LIKE '%CHECK' AND CONSTRAINT_NAME = LOWER('DF_PDV_VD_IT_LINX_PROMO_PONTOS_UNIT')) THEN
		ALTER TABLE PDV_VD_IT_LINX_PROMO DROP CONSTRAINT DF_PDV_VD_IT_LINX_PROMO_PONTOS_UNIT;
		raise notice 'Constraint DF_PDV_VD_IT_LINX_PROMO_PONTOS_UNIT deletada com sucesso !';
	ELSE 
		raise notice 'Constraint não encontrada!';
	END IF;
	
	IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = LOWER('PDV_VD_IT_LINX_PROMO') AND COLUMN_NAME = LOWER('PONTOS_UNIT')) THEN
		ALTER TABLE PDV_VD_IT_LINX_PROMO ALTER COLUMN PONTOS_UNIT TYPE DECIMAL(14,4);
		raise notice 'Coluna PONTOS_UNIT alterada! ';
	END IF;
	
	IF NOT EXISTS ( SELECT 1 FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_TYPE LIKE '%CHECK' AND CONSTRAINT_NAME = LOWER('DF_PDV_VD_IT_LINX_PROMO_PONTOS_UNIT')) THEN
		ALTER TABLE PDV_VD_IT_LINX_PROMO ADD  CONSTRAINT DF_PDV_VD_IT_LINX_PROMO_PONTOS_UNIT CHECK (PONTOS_UNIT >= 0);
		raise notice 'Constraint DF_PDV_VD_IT_LINX_PROMO_PONTOS_UNIT incluída com sucesso! ';
	END IF;
END;
$body$
language plpgsql volatile
  cost 100;
alter function addcolumn()  owner to postgres;
select addcolumn();
drop function addcolumn();
